# Check-SuricataFlows

This reads the Suricata EVE JSON flow data file.

    .timestamp :: Used for double checking to make sure we don't read farther
        back than we need to.

If the following is found, the entry is checked.

    .dest_ip
    .src_ip
    .flow.pkts_toclient
    .flow.pkts_toserver

Bi-directional is when .flow.pkts_toclient and .flow.pkts_toserver are both greater
than zero.

Uni-directional is when only .flow.pkts_toclient or .flow.pkts_toserver is greater
than zero and the other is zero.

If all entries found are uni-directional then it is safe to assume the monitored span
is misconfigured.

If more than one Suricata instance is appending to the file, you will likely want to use
-s to specify each sensor name to check for.

## FLAGS

```
check_suricataflows [-f <flows.json>] [-a <alert count>] [-w <warn
    count>] [-t <seconds>] [<-m> <max lines>]

check_suricataflows [B<-f> <flows.json>] [B<-a> <alert count>] [B<-w> <warn count>]
    [B<-t> <seconds>] [<-m> <max lines>] B<-s> <sensor> [B<-s> <sensor>]

check_suricataflows -h/--help

check_suricataflows -v/--version
```

### -f flows.json

The flows EVE JSON location.

Default: /var/log/suricata/flows/current/flow.json

### -a alert_count

Alert if the number of bidirectional flows are less than this.

Default: 10

### head2 -w warn_count

Warn if the number of directional flows are less than this.

Default: 20

### -t seconds

How far back into the file to read in seconds.

Default: 300

### -m max_lines

Max number of lines to read in.

### -s sensor

Sensor names to check for. May used more than once.

If used then each of the specified sensors is checked for. It is
checked from .host in the JSON and the variable for setting that
in the Suricata config is .sensor-name .

If more than once Suricata instance is appending to the file, then
you will most likely want to use this.

### -i IP

An IP to ignore.

# INSTALLATION

## FreeBSD

```
pkg install p5-JSON p5-File-ReadBackwards p5-App-cpanminus
cpanm Check::CheckSuricataFlows
```

## Debian

```
apt-get install libjson-perl libfile-readbackwards-perl cpanminus
cpanm Check::SuricataFlows
```

## From Source

To install this module, run the following commands:

	perl Makefile.PL
	make
	make test
	make instal
